/*jshint unused: vars */
require.config({
    paths: {

        /*                  LIBRARIES                    */
        'angular': '../libs/angular/js/angular',
        'angularAnimate': '../libs/angular-animate/js/angular-animate',
        'angularBusy': '../libs/angular-busy/js/angular-busy',
        'angularSanitize': '../libs/angular-sanitize/js/angular-sanitize',
        'angularSnap': '../libs/angular-snap/js/angular-snap',
        'angularTouch': '../libs/angular-touch/js/angular-touch',
        'angularUiBootstrap': '../libs/angular-bootstrap/js/ui-bootstrap-tpls-custom',
        'angularUiBootstrapOverwrites': '../libs/angular-bootstrap/js/ui-bootstrap-overwrites',
        'angularUiRouter': '../libs/angular-ui-router/js/angular-ui-router',
        'angularUiUtils': '../libs/angular-ui-utils/js/ui-utils',
        'clampjs': '../libs/Clamp.js/clamp',
        'highstocks': '../libs/highstock/js/highstock',
        'jQuery': '../libs/jquery/js/jquery',
        'lodash': '../libs/lodash/js/lodash',
        'moment-timezone': '../libs/moment-timezone/js/moment-timezone-with-data',
        'snap': '../libs/snap/js/snap',
        'text': '../libs/requirejs-text/text',
        'highcharts-3d': '../libs/highcharts/js/highcharts-3d.src',
        'highcharts-ng': '../libs/highcharts-ng/js/highcharts-ng_custom',
        'moment': '../libs/moment/js/moment',

        /*                  DECORATORS                    */
        'ngMaskDecoration': 'decorations/ui-mask_decorator',
        'uiCollapseDecoration': 'decorations/ui-collapse_decorator',
        'ngClickDecoration': 'decorations/ng-click_decorator',

        /*                  APPLICATION                    */
        'appConfig': 'app-config',
        'app': 'app',
        'router': 'router',

        //templates is generated by grunt ngtemplate task
        'templates': 'templates',


        /*                  CONTAINER                    */
        'MainController': 'container/main/main_controller',
        'SplashController': 'container/splash/splash_controller',

        'HeaderController': 'container/components/header/header_controller',
        'FooterController': 'container/components/footer/footer_controller',
        'TwoPanelController': 'container/components/content/two-column_controller',
        'List': 'container/components/content/list/list_directive',
        'Menu': 'container/components/menu/menu_directive',
        'SecondaryNavigationController': 'container/components/content/secondary-navigation/secondary-navigation_controller',

        /*                  FEATURE SECTIONS                    */

        // Home
        'HomeModule': 'modules/home/home_module',

        'SudController': 'core/staff-user-disclaimer/sud_controller',
        'sud_service': 'core/staff-user-disclaimer/sud_service',

        // VAR Utility
        'VarUtilitySecondaryNavigationController': 'modules/var-utility/pages/secondary-navigation/secondary-navigation-var-utility_controller',
        'InstitutionsService': 'modules/var-utility/core/institutions_service',
        'InstitutionChoiceController': 'modules/var-utility/pages/institution-choice/institution-choice_controller',
        'VarUtilityAuthorizationService': 'modules/var-utility/var-utility-authorization_service',
        'VarUtilityErrorService': 'modules/var-utility/var-utility-error_service',
        'VarUtilityModule': 'modules/var-utility/var-utility_module',
        'VarUtilityController': 'modules/var-utility/pages/var-utility_controller',
        'FormattedEmptyStringToNullValue': 'modules/var-utility/directives/formatted-empty-string-to-null-value_directive',
        'RequiredNonZeroValue': 'modules/var-utility/directives/required-non-zero-value_directive',
        'DirectSchedulingService': 'modules/var-utility/core/direct-scheduling_service',
        'DirectSchedulingController': 'modules/var-utility/pages/direct-scheduling/direct-scheduling_controller',
        'RequestsService': 'modules/var-utility/core/requests_service',
        'RequestsController': 'modules/var-utility/pages/requests/requests_controller',
		'FilterSubmittedRequestLimit': 'modules/var-utility/filters/submitted-request-limit_filter',
		'FormatStopCodes': 'modules/var-utility/filters/formatted-stop-codes_filter',
		'MovePrimaryCareToTop': 'modules/var-utility/filters/move-primary-care-to-top_filter',
        'VarUtilityConstants': 'modules/var-utility/core/var-utility_constants',
        'CustomMessagesService':'modules/var-utility/core/custom-messages_service',
		'CustomMessagesController':'modules/var-utility/pages/custom-messages/custom-messages_controller',

        // Landing - Home
		'InstitutionsService': 'modules/var-utility/core/institutions_service',
		'ChangeLocationModalController': 'modules/var-utility/pages/secondary-navigation/change-location-modal_controller',
		'InstitutionChoiceController': 'modules/var-utility/pages/institution-choice/institution-choice_controller',
		'LandingController': 'modules/home/landing/landing_controller',
        'landing_service':'modules/home/landing/landing_service',

        // Unauthorized
        'UnauthorizedController': 'modules/home/unauthorized/unauthorized_controller',

        /*                  CORE COMPONENTS                    */
        'BaseCRUDService': 'core/services/base-crud_service',
        'CollectionCRUDService': 'core/services/collection-crud_service',

        'BaseCRUDMockService': 'core/services/base-crud-mock_service',
        'CollectionCRUDMockService': 'core/services/collection-crud-mock_service',

        'httpInterceptor': 'core/connection/httpInterceptor',
        'connection_error_service': 'core/connection/connection_error_service',
        'connection_timeout_service': 'core/connection/connection_timeout_service',
        'delayManager': 'core/connection/delay_factory',

        'localResourceDirectoryService': 'core/resources/local-resource-directory_service',
        'mhpuser_service': 'core/resources/mhpuser_service',
        'patient': 'core/resources/patient_service',
        'resourcedirectory_service': 'core/resources/resourcedirectory_service',

        'escape_service': 'core/services/escape_service',
        'page_service': 'core/services/page_service',
        'formatter': 'core/services/formatter',
        'authentication_service': 'core/services/auth_service',
        'unsavedChanges': 'core/services/unsaved_changes',
        'focusManager': 'core/services/focus_directive',
        'event-bus_service': 'core/services/event-bus_service',
        'Capitalize': 'core/filters/capitalize_filter',

        /*					UI-COMPONENTS             */
        'EntryForm': 'ui-components/form/entry-form/entry-form_directive',
        'FDNS   trolWrapper': 'ui-components/form/controls/core/form-control-wrapper/form-control-wrapper_directive',

        'iOSKeyboard': 'ui-components/form/controls/core/iOS-keyboard/iOS-keyboard_directive',

        'InputRange': 'ui-components/form/controls/simple/input-range/input-range_directive',
        'InputSelect': 'ui-components/form/controls/simple/input-select/input-select_directive',
        'InputText': 'ui-components/form/controls/simple/input-text/input-text_directive',
        'AlphanumericOnly': 'ui-components/form/controls/simple/input-text/alphanumeric-only_directive',
        'InputFile': 'ui-components/form/controls/simple/input-file/input-file_directive',
        'InputNumber': 'ui-components/form/controls/simple/input-number/input-number_directive',
        'NumbersOnly': 'ui-components/form/controls/simple/input-number/numbers-only_directive',
        'InputPhone': 'ui-components/form/controls/simple/input-phone/input-phone_directive',
        'InputCheckbox': 'ui-components/form/controls/simple/input-checkbox/input-checkbox_directive',
        'InputGroupCheckbox': 'ui-components/form/controls/simple/input-group-checkbox/input-group-checkbox_directive',
        'InputGroupRadio': 'ui-components/form/controls/simple/input-group-radio/input-group-radio_directive',

        'DateControls': 'ui-components/form/controls/composite/input-date-picker/date-controls_directive',
        'TimeControls': 'ui-components/form/controls/composite/input-time-picker/time-controls_directive',
        'InputDateTime': 'ui-components/form/controls/composite/input-date-time/input-date-time_directive',
        'MultiPhone': 'ui-components/form/controls/composite/input-multi-phone/multi-phone_directive',
        'MultiTime': 'ui-components/form/controls/composite/input-multi-time-picker/multi-time_directive',

        'UserInputPattern': 'ui-components/form/validation/user-input-pattern/user-input-pattern_directive',
        'ValidationSummary': 'ui-components/form/validation/validation-summary/validation-summary',
        'ErrorHandling': 'ui-components/form/validation/validation-summary/error-handling_directive',
        'RequiredField': 'ui-components/form/validation/required-field-indicator/required-field-indicator_directive',

        'modalService': 'ui-components/modals/helper/modal_service',
        'HelpController': 'ui-components/modals/help/help_controller',
        'AboutController': 'ui-components/modals/about/about_controller',
        'ResourcesController': 'ui-components/modals/resources/resources_controller',

        'NavBar': 'ui-components/nav-bar/nav-bar_directive',
        'FilterWrapper': 'ui-components/filter/filter-wrapper_directive',
        'StatusFilter': 'ui-components/filter/status-filter/status-filter_directive',

        'DataTableDirective': 'ui-components/table/table_directive',

        'AriaHidden': 'ui-components/accessibility/aria-hidden/aria-hidden_directive',
        'iDirecitve': 'ui-components/html-extensions/i_directive',
        'clamp': 'ui-components/line-clamp/clamp_directive',
        'BackButton': 'ui-components/back-button/back-button_directive',
        'disableNgAnimate': 'ui-components/disable-ng-animate/disable-ng-animate_directive',

        'imageLightbox': 'ui-components/image/image-lightbox_directive',

        // ACCESSIBLE DIRECTIVES
        'AccessibleAccordion': 'ui-components/accordion/accessibleaccordion_directive',
        'accessibleCarousel': 'ui-components/carousel/accessible-carousel_directive',
        'AccessibleCarouselController': 'ui-components/carousel/accessible-carousel_controller',
        'accessibleDatePickerServices': 'ui-components/form/controls/simple/accessibledatepicker/accessibledatepicker_directive',
        'accessibleTimePickerServices': 'ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_directive'
    },
    shim: {
        'angular': {deps: ['jQuery'], 'exports': 'angular'},
        'jQuery': {'exports': '$'},
        'lodash': {'exports': '_'},
        'highstocks': ['jQuery'],
        'highcharts-ng': ['angular'],
        'highcharts-3d': ['highstocks'],
        'moment': {'exports': 'moment'},
        'moment-timezone': ['moment'],
        'clampjs': {'exports': '$clamp'},
        'angularSanitize': ['angular'],
        'angularUiUtils': ['angular'],
        'angularUiRouter': ['angular'],
        'angularUiBootstrap': ['angular'],
        'angularUiBootstrapOverwrites': ['angularUiBootstrap'],
        'angularTouch': ['angular'],
        'angularBusy': ['angular'],
        'angularSnap': ['angular', 'snap'],
        'angularAnimate': ['angular'],
        'templates': ['app']
    },
    priority: ['angular']
});

require(
    [
        'app',
        'angular',
        'angularTouch',
        'angularUiUtils',
        'angularUiRouter',
        'angularSanitize',
        'angularAnimate',
        'angularBusy',
        'AriaHidden',
        'AccessibleAccordion',
        'accessibleCarousel',
        'AccessibleCarouselController',
        'angularUiBootstrap',
        'angularUiBootstrapOverwrites',
        'appConfig',
        'BackButton',
        'BaseCRUDMockService',
        'BaseCRUDService',
        'clamp',
        'CollectionCRUDMockService',
        'CollectionCRUDService',
        'DataTableDirective',
        'delayManager',
        'disableNgAnimate',
        'EntryForm',
        'ErrorHandling',
        'FilterWrapper',
        'focusManager',
        'formatter',
        'FDNS   trolWrapper',
        'escape_service',
        'page_service',
        'highstocks',
        'httpInterceptor',
        'iDirecitve',
        'imageLightbox',
        'InputDateTime',
        'InputFile',
        'InputCheckbox',
        'InputGroupCheckbox',
        'InputGroupRadio',
        'InputNumber',
        'NumbersOnly',
        'InputPhone',
        'InputRange',
        'InputSelect',
        'InputText',
        'AlphanumericOnly',
        'iOSKeyboard',
        'List',
        'localResourceDirectoryService',
        'lodash',
        'Menu',
        'moment-timezone',
        'MultiPhone',
        'MultiTime',
        'NavBar',
        'ngClickDecoration',
        'ngMaskDecoration',
        'RequiredField',
        'ResourcesController',
        'router',
        'StatusFilter',
        'templates',
        'TwoPanelController',
        'uiCollapseDecoration',
        'unsavedChanges',
        'UserInputPattern',
        'ValidationSummary',
        'highcharts-3d'
    ], function (app, angular) {
        'use strict';

        angular.element().ready(function () {
            angular.bootstrap(document, [app.name]);
        });
    });
